local path = debug.getinfo(1).source
if string.sub(path, 1, 1) == "@" then
    path = string.sub(path, 2)
end
local dir = string.match(path, "(.*/)")
local lib, err = loadfile(dir .. 'lib.lua')
if lib then
    lib()
else
    error('lib.lua compile error\n' .. err)
end



local function deg2rad(deg)
	return deg / 180 * math.pi
end

local dizzySpin = math.pi * 4

local inputTable = {
   
	{ name='', length=0, rebase=0, groups={
        { offset=0, notDiff='Edit', mods={
			
			{beat=0, len=0.1, mod='XMod', from=0, val='user'},
			{beat=0, len=4, mod='Stealth', from=1, val=0, ease='SmoothStep2'},
			{beat=0, len=0.1, mod='Overhead', val=1},
			{beat=0, mod='Centered', val=0.05},
			{beat=1, len=0.1, mod='XMod', val=4.5},
			{beat=1, mod='Mini', val=0.10},
		
			
			{beat=1, len=4, actor='mask', prop='diffuse', val={1,1,1,1}, ease='SmoothStep2'},
			{beat=5.5, len=2, actor='mask', prop='zoom', val=1.5, ease='Rebound2'},
			{beat=5, len=0.5, actor='mask', prop='rotationz', val=-95, ease='SmoothStep2'},
			{beat=5.5, len=0.5, actor='mask', prop='rotationz', val=95, ease='SmoothStep2'},
			{beat=6, len=1, actor='mask', prop='rotationz', val=0, ease='SpringEnd'},
			{beat=6, len=1.5, actor='mask', prop='diffuse', val={1,0,0,0}, ease='SmoothStart4'},
			
			{beat=0, mod='Dark', val=1},
			{beat=8, len=6, mod='Dark', val=0, ease='SmoothEnd4'},
			
			--Ripple
			{beat=18, len=3, mod='DrunkZ', from=4, val=0, ease='SmoothEnd2'},
			{beat=18, len=0.5, mod='DrunkZPeriod', from=0.6, val=0.2, ease='SmoothStart2'},
			
			--Playfield Ripple Expansion
			{beat=36, len=0.625, mod='SawtoothZ', from=1.5, val=0, ease='SmoothStep4'},
			{beat=36, len=0.250, mod='Flip', val=-0.08, ease='SmoothStep3'},
            {beat=36.25, len=0.250, mod='Invert', val=-.10, ease='SmoothStep3'},
			{beat=36, len=0.50, mod='Tiny2', from=-0.75, val=0, ease='SmoothEnd3'},
			{beat=36, len=0.50, mod='Tiny3', from=-0.75, val=0, ease='SmoothEnd3'},
			
			
			{beat=37.375, len=0.250, mod='Flip', from=0.075, val=0, ease='SmoothEnd2'},
            {beat=37.375, len=0.125, mod='Invert', from=-0.08, val=0, ease='SmoothEnd2'},

			
			{beat=43.375, len=0.12, mod='Tiny', val=-0.15,  ease='SmoothStep3'},
			{beat=43.625, len=0.12, mod='Tiny', val=0.15, ease='SmoothStep3'},
			{beat=43.875, len=0.12, mod='Tiny', val=-0.15, ease='SmoothStep3'},
			{beat=44.125, len=0.12, mod='Tiny', val=0.15,  ease='SmoothStep3'},
			{beat=44.375, len=0.12, mod='Tiny', val=-0.15, ease='SmoothStep3'},
			{beat=44.625, len=0.12, mod='Tiny', val=0.15, ease='SmoothStep3'},
			
			{beat=44.500, len=0.250, mod='DrunkZPeriod', val=0, ease='SmoothEnd4'},
			
			--Going Out 
            {beat=48.667, len=0.167, mod='Invert', val=0.03125},
            {beat=48.667, len=0.167, mod='Flip', val=-0.14+0.09375},
            {beat=48.834, len=0.167, mod='Invert', val=0},
            {beat=49, len=0.167, mod='Flip', val=-0.14+0},
            {beat=49.333, len=0.167, mod='Invert', val=0.015625},
            {beat=49.667, len=0.167, mod='Flip', val=-0.14+-0.046875},
            {beat=49.834, len=0.167, mod='Invert', val=0},
            {beat=50, len=0.167, mod='Flip', val=-0.14+0},
			{beat=50.500, len=0.175, mod='Flip', val=0, ease='SmoothEnd2'},
			--added kick enhancement
			{beat=50.675, len=0.125, mod='Flip', val=0.15, ease='SmoothEnd2'},
			{beat=50.875, len=0.125, mod='Flip', val=0, ease='SmoothEnd2'},
			
			
			--Going Out Again
			{beat=51.667, len=0.167, mod='Invert', val=0.03125},
            {beat=51.667, len=0.167, mod='Flip', val=-0.14+0.09375},
            {beat=51.834, len=0.167, mod='Invert', val=0},
            {beat=52, len=0.167, mod='Flip', val=-0.14+0},
            {beat=52.333, len=0.167, mod='Invert', val=0.015625},
            {beat=52.667, len=0.167, mod='Flip', val=-0.14+-0.046875},
            {beat=52.834, len=0.167, mod='Invert', val=0},
            {beat=53, len=0.167, mod='Flip', val=-0.14+0},
			{beat=53.500, len=0.175, mod='Flip', val=0, ease='SmoothEnd2'},
			{beat=53.675, len=0.125, mod='Flip', val=0.07, ease='SmoothEnd2'},
			{beat=53.875, len=0.125, mod='Flip', val=0, ease='SmoothEnd2'},
			
			
			--Going Out 3rd Time
			{beat=54.667, len=0.167, mod='Invert', val=0.03125},
            {beat=54.667, len=0.167, mod='Flip', val=-0.14+0.09375},
            {beat=54.834, len=0.167, mod='Invert', val=0},
            {beat=55, len=0.167, mod='Flip', val=-0.14+0},
            {beat=55.333, len=0.167, mod='Invert', val=0.015625},
            {beat=55.667, len=0.167, mod='Flip', val=-0.14+-0.046875},
            {beat=55.834, len=0.167, mod='Invert', val=0},
            {beat=56, len=0.167, mod='Flip', val=-0.14+0},
			{beat=56.500, len=0.175, mod='Flip', val=0, ease='SmoothEnd2'},
			{beat=56.675, len=0.125, mod='Flip', val=0.15, ease='SmoothEnd2'},
			{beat=56.875, len=0.125, mod='Flip', val=0, ease='SmoothEnd2'},
			
			--Going Out 4th Time
			{beat=57.667, len=0.167, mod='Invert', val=0.03125},
            {beat=57.667, len=0.167, mod='Flip', val=-0.14+0.09375},
            {beat=57.834, len=0.167, mod='Invert', val=0},
            {beat=58, len=0.167, mod='Flip', val=-0.2+0},
            {beat=58.333, len=0.167, mod='Invert', val=0.015625},
            {beat=58.667, len=0.167, mod='Flip', val=-0.14+-0.046875},
            {beat=58.834, len=0.167, mod='Invert', val=0},
            {beat=59, len=0.167, mod='Flip', val=-0.14+0},
			{beat=59.500, len=0.175, mod='Flip', val=0, ease='SmoothEnd2'},
			{beat=59.675, len=0.125, mod='Flip', val=0.15, ease='SmoothEnd2'},
			{beat=59.875, len=0.125, mod='Flip', val=0, ease='SmoothEnd2'},
			

			
			--Puffing up Arrows
			{beat=48.375, len=0.75, mod='Tiny', val=-0.35, ease='SmoothEnd4'},
			{beat=49.500, len=0.125, mod='Tiny', val=0.25, ease='SmoothStep3'},
		
			{beat=51.500, len=0.75, mod='Tiny', val=-0.35, ease='SmoothEnd4'},
			{beat=52.375, len=0.125, mod='Tiny', val=0.25, ease='SmoothStep3'},
			
			{beat=54.500, len=0.75, mod='Tiny', val=-0.35, ease='SmoothEnd4'},
			{beat=55.375, len=0.125, mod='Tiny', val=0.25, ease='SmoothStep3'},
			
			{beat=57.500, len=0.75, mod='Tiny', val=-0.40, ease='SmoothEnd4'},
			{beat=58.375, len=0.125, mod='Tiny', val=0.25, ease='SmoothStep3'},
			{beat=58.875, len=1.125, mod='Tiny', val=0, ease='SmoothStep2'},
			
				
				
			
			
					
			
			{beat=48, len=0.250, mod='BounceZ', val=2, ease='SmoothStep2'},
			{beat=48.500,  mod='BounceZPeriod', val=0.9},
			{beat=48.500, mod='BounceZOffset', val=0.75},
			{beat=48.500,  mod='BounceZPeriod', val=0.9},

			
			{beat=60, mod='DrunkZ', val=0.8, ease='SmoothEnd4'},
			{beat=60,  mod='DrunkZPeriod', val=0.1},
			{beat=59.5, mod='DrunkZOffset', val=0.75},
			
			{beat=59.750, len=0.250, mod='Expand', val=0.5, ease='SmoothStart4'},
			{beat=59.750, len=0.250, mod='ExpandPeriod', val=0.2, ease='SmoothStart4'},
			{beat=84, len=4, mod='Expand', from=0.5, val=0, ease='SmoothEnd4'},
			{beat=82, len=4, mod='Stealth', val=0.95},
			
			--Soak it in
			{beat=82.5, msg='StatsHide'},
			{beat=100.5, msg='StatsShow'},
			
			{beat=91, len=0.25, mod='DrunkZPeriod', val=0},
			{beat=91, len=0.25, mod='DrunkZOffset', val=0},
			{beat=91, len=0.250, mod='BounceZ', val=0, ease='SmoothStep2'},
			{beat=91,  mod='BounceZPeriod', val=0},
			{beat=91, mod='BounceZOffset', val=0},
			{beat=91,  mod='BounceZPeriod', val=0},
			
			--You have my attention
			{beat=92.875, len=0.125, mod='DrunkZ', val=0, ease='SmoothEnd4'},
			{beat=92.875, len=0.525, mod='Cross', from=0.15, val=0, ease='SpringEnd'},
			{beat=92.875, len=0.525, mod='MoveX1', from=-1, val=0, ease='SpringEnd'},
			{beat=92.875, len=0.525, mod='MoveX4', from=-1, val=0, ease='SpringEnd'},
			
			{beat=94.75, len=0.25, mod='ConfusionOffset', val=-0.5*math.pi, ease='SmoothEnd4'},
            {beat=95.25, len=0.25, mod='ConfusionOffset', val=-1.0*math.pi, ease='SmoothEnd4'},
            {beat=95.75, len=0.25, mod='ConfusionOffset', val=-1.5*math.pi, ease='SmoothEnd4'},
            
			
			{beat=96.25, len=0.25, mod='ConfusionOffset', val=-2.0*math.pi, ease='SmoothEnd4'},
			{beat=96.75, len=0.25, mod='ConfusionOffset', val=0.5*math.pi, ease='SmoothEnd4'},
            {beat=97.25, len=0.25, mod='ConfusionOffset', val=1.0*math.pi, ease='SmoothEnd4'},
            {beat=97.75, len=0.25, mod='ConfusionOffset', val=1.5*math.pi, ease='SmoothEnd4'},
            {beat=98.25, len=0.25, mod='ConfusionOffset', val=2.0*math.pi, ease='SmoothEnd4'},
			{beat=98.75, len=0.25, mod='ConfusionOffset', val=-0.5*math.pi, ease='SmoothEnd4'},
            {beat=99.25, len=0.25, mod='ConfusionOffset', val=-1.0*math.pi, ease='SmoothEnd4'},
			{beat=99.75, len=0.25, mod='ConfusionOffset', val=-1.5*math.pi, ease='SmoothEnd4'},
            {beat=100.25, len=0.25, mod='ConfusionOffset', val=-2.0*math.pi, ease='SmoothEnd4'},
            {beat=100.75, len=0.25, mod='ConfusionOffset', val=0.5*math.pi, ease='SmoothEnd4'},
            {beat=101.25, len=0.25, mod='ConfusionOffset', val=1.0*math.pi, ease='SmoothEnd4'},
			{beat=101.75, len=0.25, mod='ConfusionOffset', val=1.5*math.pi, ease='SmoothEnd4'},
            {beat=102.25, len=0.25, mod='ConfusionOffset', val=2.0*math.pi, ease='SmoothEnd4'},
			
			
			--Stealth attack
		
            {beat=98.25, len=0.25, mod='Stealth', from=0.85, val=0.95, ease='SmoothStart2'},
			{beat=98.75, len=0.25, mod='Stealth', from=0.80, val=0.95, ease='SmoothStart2'},
            {beat=99.25, len=0.25, mod='Stealth', from=0.75, val=0.95, ease='SmoothStart2'},
			{beat=99.75, len=0.25, mod='Stealth', from=0.70, val=0.95, ease='SmoothStart2'},
            {beat=100.25, len=0.25, mod='Stealth',from=0.65, val=0.95, ease='SmoothStart2'},
            {beat=100.75, len=0.25, mod='Stealth', from=0.60, val=0.95, ease='SmoothStart2'},
            {beat=101.25, len=1, mod='Stealth', from=0.25, val=0, ease='SmoothStart2'},
		

			
			{beat=98.5, len=3, mod='Centered', val=0.12, ease='SmoothStart4'},
			{beat=98.5, len=3, mod='Mini', val=0.25, ease='SmoothStep3'},

			
			{beat=102.25, len=0.5, mod='Stealth', val=0, ease='SmoothStep2'},
			
			
			--Run away Kevin!
			{beat=102.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=104.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=105.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd3'},
			{beat=107.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=108.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd3'},
			{beat=110.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},	
			{beat=111.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd3'},
			{beat=113.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},			
			
			{beat=114.75, len=0.25, mod='Hallway', val=0.75, ease='SmoothStep2'},
			{beat=116, len=0.25, mod='Hallway', val='0', ease='SmoothStart3'},
			{beat=114.75, len=1.5, mod='Reverse', val=-0.05, ease='SmoothEnd3'},
			{beat=116.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},	
			
			
			
			{beat=114.875, len=0.125, mod='MoveX4', val=-0.5, ease='Rebound4'},			
			{beat=115.125, len=0.125, mod='MoveY3', val=-0.5, ease='Rebound2'},
			{beat=115.375, len=0.125, mod='MoveX1', val=-0.5, ease='Rebound4'},
			{beat=115.625, len=0.125, mod='MoveY2', val=-0.5, ease='Rebound2'},
			{beat=115.875, len=0.125, mod='MoveX4', val=-0.5, ease='Rebound4'},
			{beat=116.125, len=0.125, mod='MoveY3', val=-0.5, ease='Rebound2'},
			
			
			{beat=117.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=119.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=120.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=122.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=123.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=125.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},			

			--REV IT UP
			{beat=125.500, len=1.25, mod='TanBumpyX', from=1, val=0, ease='SmoothEnd4'},
			
			{beat=125.500, len=0.5, mod='Space', val=0.35, ease='SmoothStep3'},
			
			
			{beat=127.000, len=4.5, mod='ConfusionOffset4', val=1.25*dizzySpin, ease='Rebound4'},
			{beat=127.000, len=4.5, mod='ConfusionOffset1', val=1.25*dizzySpin, ease='Rebound4'},
			{beat=127.500, len=0.5, mod='ConfusionOffset2', val=0.10, ease='Rebound4'},
			{beat=128.000, len=0.5, mod='ConfusionOffset3', val=0.10, ease='Rebound4'},
			{beat=128.500, len=0.5, mod='ConfusionOffset2', val=0.10, ease='Rebound4'},
			{beat=129.000, len=0.5, mod='ConfusionOffset3', val=0.10, ease='Rebound4'},
			{beat=129.500, len=0.5, mod='ConfusionOffset2', val=0.10, ease='Rebound4'},
			{beat=130.000, len=0.5, mod='ConfusionOffset3', val=0.10, ease='Rebound4'},
			{beat=130.500, len=0.5, mod='ConfusionOffset2', val=0.10, ease='Rebound4'},
			{beat=131.000, len=0.5, mod='ConfusionOffset3', val=0.10, ease='Rebound4'},
			
			{beat=133.000, len=4.5, mod='ConfusionOffset3', val=1.25*dizzySpin, ease='Rebound4'},
			{beat=133.000, len=4.5, mod='ConfusionOffset2', val=1.25*dizzySpin, ease='Rebound4'},
			{beat=133.500, len=0.5, mod='ConfusionOffset1', val=0.10, ease='Rebound4'},
			{beat=134.000, len=0.5, mod='ConfusionOffset4', val=0.10, ease='Rebound4'},
			{beat=134.500, len=0.5, mod='ConfusionOffset1', val=0.10, ease='Rebound4'},
			{beat=135.000, len=0.5, mod='ConfusionOffset4', val=0.10, ease='Rebound4'},
			{beat=135.500, len=0.5, mod='ConfusionOffset1', val=0.10, ease='Rebound4'},
			{beat=136.000, len=0.5, mod='ConfusionOffset4', val=0.10, ease='Rebound4'},
			{beat=136.500, len=0.5, mod='ConfusionOffset1', val=0.10, ease='Rebound4'},
			{beat=137.000, len=0.5, mod='ConfusionOffset4', val=0.10, ease='Rebound4'},
			
			
			{beat=139.000, len=4.5, mod='ConfusionOffset4', val=1.25*dizzySpin, ease='Rebound4'},
			{beat=139.000, len=4.5, mod='ConfusionOffset1', val=1.25*dizzySpin, ease='Rebound4'},
			{beat=139.500, len=0.5, mod='ConfusionOffset2', val=0.10, ease='Rebound4'},
			{beat=140.000, len=0.5, mod='ConfusionOffset3', val=0.10, ease='Rebound4'},
			{beat=141.500, len=0.5, mod='ConfusionOffset2', val=0.10, ease='Rebound4'},
			{beat=141.000, len=0.5, mod='ConfusionOffset3', val=0.10, ease='Rebound4'},
			{beat=141.500, len=0.5, mod='ConfusionOffset2', val=0.10, ease='Rebound4'},
			{beat=142.000, len=0.5, mod='ConfusionOffset3', val=0.10, ease='Rebound4'},
			{beat=142.500, len=0.5, mod='ConfusionOffset2', val=0.10, ease='Rebound4'},
			{beat=143.000, len=0.5, mod='ConfusionOffset3', val=0.10, ease='Rebound4'},
			
			{beat=145.000, len=4.5, mod='ConfusionOffset3', val=1.25*dizzySpin, ease='Rebound4'},
			{beat=145.000, len=4.5, mod='ConfusionOffset2', val=1.25*dizzySpin, ease='Rebound4'},
			{beat=145.500, len=0.5, mod='ConfusionOffset1', val=0.10, ease='Rebound4'},
			{beat=146.000, len=0.5, mod='ConfusionOffset4', val=0.10, ease='Rebound4'},
			{beat=146.500, len=0.5, mod='ConfusionOffset1', val=0.10, ease='Rebound4'},
			{beat=147.000, len=0.5, mod='ConfusionOffset4', val=0.10, ease='Rebound4'},
			{beat=147.500, len=0.5, mod='ConfusionOffset1', val=0.10, ease='Rebound4'},
			{beat=148.000, len=0.5, mod='ConfusionOffset4', val=0.10, ease='Rebound4'},
			{beat=148.500, len=0.5, mod='ConfusionOffset1', val=0.10, ease='Rebound4'},
			{beat=149.000, len=0.5, mod='ConfusionOffset4', val=0.10, ease='Rebound4'},
			
			
			
			
			{beat=126.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=128.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=129.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=131.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=133.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=134.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=135.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=137.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=138.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=140.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=141.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=143.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=144.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=146.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			{beat=147.75, len=1.5, mod='Reverse', val=-0.15, ease='SmoothEnd2'},
			{beat=149.25, len=1.25, mod='Reverse', val=0, ease='SpringEnd'},
			
			
			{beat=150.75, len=0.25, mod='Space', val=0, ease='SmoothStep2'},
			
		
			{beat=163.000, len=1, mod='TanTornado', from=.1, val=0, ease='SmoothEnd4'},
			
		
		} },
    } },
}

local distanceUnit = SCREEN_HEIGHT/10

local actors = {
    {
        name='mask',
        src='heard.png',
        init={
            x=(SCREEN_CENTER_X),
            y=SCREEN_CENTER_Y+distanceUnit*2,
            diffuse={1,1,1,0},
			zoom=0.25,
			
			
			
        },
		
    },
}

local function setStatsVisible(v)
	local uiActor = SCREENMAN:GetTopScreen():GetChild('Underlay')
	if uiActor then
		uiActor:smooth(1.6)
		uiActor:diffusealpha(v and 1 or 0)
	end
end

return Def.ActorFrame{
    LibActor{
        inputTable=inputTable,
		actors=actors,
        usePlayFieldMods=false,
        showDebug=false,
    },
	Def.Quad{
        InitCommand=function(self) self:visible(false) end,
        OnCommand=function(self) self:sleep(9999) end,
		StatsShowMessageCommand=function(self) setStatsVisible(true) end,
		StatsHideMessageCommand=function(self) setStatsVisible(false) end,
    }
}
